//+------------------------------------------- 
//| BatteryInfo Widget
//+------------------------------------------- 
//| Version 1.2b
//+------------------------------------------- 
//+-------------------------------------------
//| Copyrights:
//| Copyright 2005 Ben Barnett
//| ludge@spymac.com
//+-------------------------------------------

/***
* Sets a few vars
*
* updateInterval	How often to update the widget
* updateTimer				The object for setInterval
***/
var updateInterval = 10000;
var updateTimer = null;
var showInfo = 'none';
var batteryInfo = new Array();
var hmmm = '';

/***
* Sets up widget after being run
*
* Sets onshow and onhide events
***/
function setup() {
	if (window.widget)
	{
    	widget.onshow = onshow;
    	widget.onhide = onhide;
	}
}


/***
* Sets up widget for showing
*
* Loads localized strings
* Gets preferences
* Updates the back to show current prefs
* Shows the battery status
* Sets the loop to update the status
***/
function onshow() {
	loadLocalizedStrings();
	getPrefs();
	updatePrefs();
	showStatus();
	if (updateTimer == null)
		{

		updateTimer = setInterval("showStatus()", Number(updateInterval));
		}
	else
		{
		clearInterval(updateTimer);
		updateTimer = null;
		

		updateTimer = setInterval("showStatus()", Number(updateInterval));
		}
}


/***
* Sets widget for hiding
*
* Destroys the loop
* Saves preferences
***/
function onhide() {
	if (updateTimer != null)
	{
	clearInterval(updateTimer);
	updateTimer = null;
	}
	
	widget.setPreferenceForKey(updateInterval, "updateInterval");
}


/***
* Displays the battery status
*
* Gets info
* Gets percentage from info
* Selects image number from percentage
* Prepends image number with relevant status choice
*
* Displays the image
***/
function showStatus() {
	
if (window.widget)
	{
	systemType = getBatteryStatus();

	if (systemType == 'desktop')
		{
		document.getElementById("status").src = "images/desktop_notice.png";
		document.getElementById("info").style.display ='none';
		resizeTo(128, 128);
		return;
		}
	
	var image = selectImage(batteryInfo['percentage']);
	
	// If we can't choose an image
	if (image == 'no_image')
		{
		document.getElementById("status").src = "images/0.png";
		}
	// Otherwise, display it!
	else
		{
		
		switch (batteryInfo['status'])
			{
			case 'discharging':
			document.getElementById("status").src = "images/"+image;
			break;	
			
			case 'charging':
			document.getElementById("status").src = "images/charging_"+image;
			break;
			
			case 'AC attached':
			
			if(batteryInfo['remaining'] == 'not_charging')
				{
					// Battery is CHARGED
				document.getElementById("status").src = "images/charged.png";
				}	
			else
				{
					// Battery is CHARGING
				document.getElementById("status").src = "images/charging_"+image;
				}
			break;
	
			case 'removed':
			document.getElementById("status").src = "images/0.png";
			break;
			
			default:
			// If all else fails. Display an empty battery
			document.getElementById("status").src = "images/0.png";
			break;
			}
		}
		
	//
	// Text label time!
	//
	if (showInfo == 'percentage')
		{
		document.getElementById('infotext').innerText = batteryInfo['percentage']+'%';
		}
		
	else if (showInfo == 'time')
		{
		// Battery Full
		if (batteryInfo['remaining'] == 'not_charging')
			{
			document.getElementById('infotext').innerText = getLocalizedString('batteryfull');
			}
		
		// Calculating Time
		else if (batteryInfo['remaining'] == 'no_estimate')
			{
			document.getElementById('infotext').innerText = getLocalizedString('noestimate');
			}
		// We have a time..
		else
			{
			// ...remaining
			if (batteryInfo['status'] == 'discharging')
				{
				document.getElementById('infotext').innerText = batteryInfo['remaining']+' '+getLocalizedString('remaining');
				}
			// ...or until fully charged
			else if (batteryInfo['status'] == 'charging')
				{
				document.getElementById('infotext').innerText = batteryInfo['remaining']+' '+getLocalizedString('untilfull');
				}
			// There is no battery installed	
			else if (batteryInfo['status'] == 'removed')
				{
				document.getElementById('infotext').innerText = getLocalizedString('nobattery');
				}	
			
			}
		}
	}
}


/***
* Gets Battery Info
*
* Gets raw battery info from pmset
***/
function getBatteryStatus() {

	// Get raw battery info	
	var resultString = widget.system("/usr/bin/pmset -g batt", null).outputString;
	// Split at newline
	tempString = resultString.split(/\n/);
	
	if ( (tempString[1] == '') || (tempString[1] == null) )
		{
		return 'desktop';
		}
		
	temp = tempString[1].split(/\t/);
	
	if (temp[1] == '(removed)')
		{
		batteryInfo['percentage'] = 0;
		batteryInfo['status'] = 'removed';
		batteryInfo['remaining'] = 'no_battery';
		return;
		}
	
	temp = temp[1].split(';');
	
	batteryInfo['percentage'] = temp[0].replace(';', '');
	batteryInfo['percentage'] = temp[0].replace('%', '');
	batteryInfo['status'] = temp[1].replace(' ', '');

	switch (temp[2])
		{
		case ' not charging':
			batteryInfo['remaining'] = 'not_charging';
		break;
		
		case ' (no estimate) ':
			batteryInfo['remaining'] = 'no_estimate';
		break;
		
		default:
			temp = temp[2].split(' ');
			batteryInfo['remaining'] = temp[1];
		break;
		}

	
return true;
}




	




/***
* Chooses which image to load
*
* 10 images
***/
function selectImage(percentage) {
	if (percentage > 95)
		{
		return "10.png";
		}
	else if ( (percentage > 85) && (percentage <= 95) )
		{
		return "9.png";
		}
	else if ( (percentage > 75) && (percentage <= 85) )
		{
		return "8.png";
		}
	else if ( (percentage > 65) && (percentage <= 75) )
		{
		return "7.png";
		}
	else if ( (percentage > 55) && (percentage <= 65) )
		{
		return "6.png";
		}
	else if ( (percentage > 45) && (percentage <= 55) )
		{
		return "5.png";
		}
	else if ( (percentage > 35) && (percentage <= 45) )
		{
		return "4.png";
		}
	else if ( (percentage > 25) && (percentage <= 35) )
		{
		return "3.png";
		}
	else if ( (percentage > 15) && (percentage <= 25) )
		{
		return "2.png";
		}
	else if ( (percentage > 5) && (percentage <= 15) )
		{
		return "1.png";
		}
	else if (percentage <= 5)
		{
		return "0.png";
		}
	else
		{
		return "no_image"
		}
}


/***
* Loads Preferences
*
* PREFS:
* updateInterval	How often the widget should update in milliseconds
***/
function getPrefs() {
	if (window.widget)
		{
		updateInterval = widget.preferenceForKey("updateInterval");
		
		if (isNaN(updateInterval))
			{
			updateInterval = 10000;
			}
		
		
		showInfo = widget.preferenceForKey("showInfo");
		
		if ( (showInfo == 'percentage') || (showInfo == 'time') )
	    	{
	    	resizeTo(128, 135);
	    	document.getElementById('info').style.display = 'block';
	    	}
	    else
	    	{
	    	document.getElementById('info').style.display = 'none';
	    	resizeTo(128, 128);
	    	}
		}
}


/***
* Saves preferences
*
* Called whenever an option changes.
* Saves to plist, then resets timer
***/
function setPrefs(elem)
{
	
if(window.widget)
	{

	udI = document.getElementById('updateInterval');
	updateInterval = udI.options[udI.selectedIndex].value;	
	
	
	if (elem == 'percentage')
		{
		showInfo = 'percentage';
		}
	else if (elem == 'time')
		{
		showInfo = 'time';
		}
	else if (elem == 'none')
		{
		showInfo = 'none';
		}
		
	widget.setPreferenceForKey(updateInterval, "updateInterval");
	widget.setPreferenceForKey(showInfo, "showInfo");
	
	if (updateTimer == null)
		{

		updateTimer = setInterval("showStatus()", Number(updateInterval));
		}
	else
		{
		clearInterval(updateTimer);
		updateTimer = null;
		

		updateTimer = setInterval("showStatus()", Number(updateInterval));
		}
	
	}


}


/***
* Updates back of widget
*
* Sets the various controls to display the 
* current preference. Called on loading.
***/
function updatePrefs() {
	

	var selectPref = document.getElementById('prefs').updateInterval;
	
	with (selectPref) {
		selectedIndex = 0; 
		for (var i=0; i<options.length; i++) {
			if (options[i].value == updateInterval)
				selectedIndex = i;
		}
	}

	
	
	if (showInfo == 'percentage')
		{
		document.getElementById('prefs').displayInfo[0].checked = true;
		}
	else if (showInfo == 'time')
		{
		document.getElementById('prefs').displayInfo[1].checked = true;
		}
	else
		{
		document.getElementById('prefs').displayInfo[2].checked = true;
		}
}

/***
* Flips the widget over (To BACK)
*
* Flips & Resizes
***/
function showPrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
        
    if (window.widget)
    	{
    	document.getElementById("flip").style.opacity = 0;
    	document.getElementById("fliprollie").style.display = 'none';
    	
    	window.resizeTo (172, 135);
        widget.prepareForTransition("ToBack");
        
    	}
    	        
    front.style.display="none";
    back.style.display="block";
        
    if (window.widget)
    	{
        setTimeout ('widget.performTransition();', 0);  
        window.resizeTo (172, 128);
    	}
}


/***
* Flips the widget over (To FRONT)
*
* Flips & Resizes
***/
function hidePrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
    
        
    if (window.widget)
	{
	if ( (showInfo == 'percentage') || (showInfo == 'time') )
    	{
    	document.getElementById('info').style.display = 'block';
    	resizeTo(172, 135);
    	}
    	
    widget.prepareForTransition("ToFront");
	}
                
    back.style.display = "none";
    front.style.display = "block";
    document.getElementById('fliprollie').style.display = 'none';
        
    if (window.widget)
	{
    setTimeout ('widget.performTransition();', 0);
    
	if ( (showInfo == 'percentage') || (showInfo == 'time') )
	    	{
	    	document.getElementById('info').style.display = 'block';
	    	resizeTo(128, 135);
	    	}
	    else
	    	{
	    	document.getElementById('info').style.display = 'none';
	    	resizeTo(128, 128);
	    	}
	    if (showInfo == 'percentage')
		    {
		    
		    }
		if (showInfo == 'time')
			{
			
			}

	}
}



/***
* Functions to convert decimal to hex (d2h();) and 
* back again (h2d();)
***/
var hD="0123456789ABCDEF";
function d2h(d) {
var h = hD.substr(d&15,1);
while(d>15) {d>>=4;h=hD.substr(d&15,1)+h;}
return h;
}
function h2d(h) {return parseInt(h,16);}



/***
* Shows "flip i" background
***/
function showFlip()
{
	document.getElementById('fliprollie').style.display = 'block';
}

/***
* Hides "flip i" background
***/
function hideFlip()
{
	document.getElementById('fliprollie').style.display = 'none';
}


/***
* Opens link
***/
function openUrl(url) 
	{
	if (window.widget) 
		{
		widget.openURL(url);
		}
	else 
		{
		window.open(url);
		}
}


/***
* Get localized string
*
* Will return a string in the users language if available,
* or will use the element ID instead
***/
function getLocalizedString (key)
{
    try {
        var ret = localizedStrings[key];
        if (ret === undefined)
            ret = key;
        return ret;
    } catch (ex) {}
    return key;
}

/***
* Loads strings for display
*
* Called from onShow, this loads the correct
* language strings.
***/
function loadLocalizedStrings()
{	
	document.getElementById('updateevery').innerText = getLocalizedString('updateevery');
	document.getElementById('seconds').innerText = getLocalizedString('seconds');
	document.getElementById('showpercentage').innerText = getLocalizedString('showpercentage');
	document.getElementById('showtime').innerText = getLocalizedString('showtime');
	document.getElementById('shownone').innerText = getLocalizedString('shownone');
}


// APPLE'S FLIP AND FADE CODE
//------------------------------------

var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};
function mousemove (event)
{
    if (!flipShown)
    {
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 1.0;
        animate();
        flipShown = true;
    }
}
function mouseexit (event)
{
    if (flipShown)
    {
        // fade in the info button
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 0.0;
        animate();
        flipShown = false;
    }
}
function animate()
{
    var T;
    var ease;
    var time = (new Date).getTime();
                
        
    T = limit_3(time-animation.starttime, 0, animation.duration);
        
    if (T >= animation.duration)
    {
        clearInterval (animation.timer);
        animation.timer = null;
        animation.now = animation.to;
    }
    else
    {
        ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
        animation.now = computeNextFloat (animation.from, animation.to, ease);
    }
        
    animation.firstElement.style.opacity = animation.now;
}
function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}
function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}


